;***********************************
;** OCCUPIED REGS.: A5,A6         **
;** (C) 1990 STalin OF F.F.       **
;***********************************

EXEC=0              ;-1 FOR EXECUTABLE

 IFEQ EXEC,0
SCR1=$F0000         ;$70000 for 520!!!
 ELSE
SCR1=$70000
 ENDIF

SCR2=SCR1+32000

 JMP START

BUFF:
 DS.B 2500,0


VBL:
 MOVE.B SCREENS+5,$FF8201
 MOVE.B SCREENS+6,$FF8203
 ST SYNCF
 ADDQ.W #1,CLOCK
; MOVEM.L D0-D7/A0-A3,-(SP)
 MOVE.W #$000,(A6)

; MOVEM.L (SP)+,D0-D7/A0-A3
 LEA COLTAB(PC),A5
 CLR.B $FFFA1B
 MOVE.B #2,$FFFA21
 MOVE.B #8,$FFFA1B
 RTE
SCOL: DC.W 0
SCOLA: DC.L BUFF
SYNCF: DC.W 0


MAIN:
 TST.B SYNCF
 BEQ.S MAIN
 CLR.B SYNCF

 MOVE.L SCREENS,D0
 MOVE.L SCREENS+4,D1
 EXG.L D0,D1
 MOVE.L D0,SCREENS
 MOVE.L D1,SCREENS+4

 MOVEM.L A5-A6,-(SP)
 JSR MUSIC+$38(PC)
 MOVEM.L (SP)+,A5-A6
 JSR BLACKSPRITES(PC)
 JSR BLACKFF2(PC)
 JSR BLACKFF(PC)
 JSR MEGAFF2(PC)
 JSR SCROLL(PC)
 JSR SPRITES(PC)
 JSR MEGAFF(PC)

 IFNE EXEC,-1
   MOVE.W #$777,$FF8240
 ENDIF

 CMP.B #$39,$FFFC02
 BEQ EXIT

 BRA.S MAIN


SPRITES:
 MOVE.L SCREENS(PC),A1

SPEK1:    ;PEK!
 MOVE.W REFLEXY1,D0
 BNE.S SPR1
   MOVE.L #REFLEXY1,SPEK1+2
   MOVE.W REFLEXY1,D0
SPR1:
 ADDQ.L #2,SPEK1+2
 SUB.W #64-2,D0
 ADD.W D0,A1

SPEK3:    ;PEK!
 MOVE.W REFLEXX1,D0
 BNE.S SPR2
   MOVE.L #REFLEXX1,SPEK3+2
   MOVE.W REFLEXX1,D0
SPR2:
 ADDQ.L #2,SPEK3+2

SPEK4:    ;PEK!
 MOVE.W REFLEXX2,D1
 BNE.S SPR3
   MOVE.L #REFLEXX2,SPEK4+2
   MOVE.W REFLEXX2,D1
SPR3:
 ADDQ.L #2,SPEK4+2
 ADD.W D1,D0

 CMP.W #192,D0
 BLE.S SPR4
   MOVE.W #192,D0
SPR4:
 MOVE.W D0,D1
 AND.B #240,D0
 LSR.W #1,D0
 ADD.W D0,A1
 AND.W #15,D1
 LSL.W #7,D1
 LSL.W #3,D1   ;*1024
 LEA REFGRAF+32768,A2   ;MASK
 ADD.W D1,A2
 LSL.W #1,D1   ;*2048
 LEA REFGRAF,A0         ;GX
 ADD.W D1,A0
SPEK2:
 MOVE.L A1,BADDS

L@=0
N@=0
 REPEAT
  MOVEM.L L@(A1),D0-D7
  AND.L (A2),D0
  OR.L (A0)+,D0
  AND.L (A2)+,D1
  OR.L (A0)+,D1

  AND.L (A2),D2
  OR.L (A0)+,D2
  AND.L (A2)+,D3
  OR.L (A0)+,D3

  AND.L (A2),D4
  OR.L (A0)+,D4
  AND.L (A2)+,D5
  OR.L (A0)+,D5

  AND.L (A2),D6
  OR.L (A0)+,D6
  AND.L (A2)+,D7
  OR.L (A0)+,D7

  MOVEM.L D0-D7,L@(A1)

  MOVEM.L L@+32(A1),D0-D7
  AND.L (A2),D0
  OR.L (A0)+,D0
  AND.L (A2)+,D1
  OR.L (A0)+,D1

  AND.L (A2),D2
  OR.L (A0)+,D2
  AND.L (A2)+,D3
  OR.L (A0)+,D3

  AND.L (A2),D4
  OR.L (A0)+,D4
  AND.L (A2)+,D5
  OR.L (A0)+,D5

  AND.L (A2),D6
  OR.L (A0)+,D6
  AND.L (A2)+,D7
  OR.L (A0)+,D7

  MOVEM.L D0-D7,L@+32(A1)

L@=L@+160
N@=N@+1
 UNTILEQ N@,32
 RTS


BLACKSPRITES:
 MOVEQ #0,D0
 MOVEQ #0,D1
 MOVEQ #0,D2
 MOVEQ #0,D3
 MOVEQ #0,D4
 MOVEQ #0,D5
 MOVEQ #0,D6
 MOVEQ #0,D7
 LEA BADDS(PC),A0
 BTST #0,CLOCK+1
 BNE.S BSPR1
   ADDQ.W #4,A0
BSPR1:
 MOVE.L (A0),A1
 MOVE.L A0,SPEK2+2
N@=0
L@=0
 REPEAT
   MOVEM.L D0-D7,L@(A1)
   MOVEM.L D0-D7,L@+32(A1)
N@=N@+1
L@=L@+160
 UNTILEQ N@,32
 RTS
BADDS: DC.L SCR1,SCR1


SCROLL:    ;PEK!
 LEA SCROLLER,A0
 CMP.L #SCROLLER + ((ASCEND-ASCII-25)*8),A0
 BNE.S SCRL1
   MOVE.L #SCROLLER,SCROLL+2
SCRL1:
 ADDQ.L #1,SCROLL+2
 MOVE.L SCREENS(PC),A1

;L@=159
;N@=0
; REPEAT
;   MOVE.B (A0)+,L@(A1)
;L@=L@+160
;N@=N@+1
; UNTILEQ N@,200

 ADD.W #159,A1     ;REWRITTEN TO SAVE SOME MEMORY
 MOVE.W #160,D1
 MOVE.W #199,D0
SCRL2:
 MOVE.B (A0)+,(A1)
 ADD.W D1,A1
 DBRA D0,SCRL2
 RTS



MEGAFF2:   ;PEK!
 LEA MEGADD2,A0
 LEA 0,A3
 MOVE.W (A0)+,A3
 CMP.W #-1,A3
 BNE.S YY22
   LEA MEGADD2(PC),A0
   MOVE.W (A0)+,A3
YY22:
 MOVE.L A0,MEGAFF2+2

   LEA BTAB2(PC),A4
   BTST #0,CLOCK+1
   BEQ.S YY23
     ADDQ.W #8,A4
YY23:

 MOVE.L SCREENS(PC),A1
YPEK21:
 MOVE.W MEGAY+80,D0           ;Y COORD
 BNE.S YY21
   MOVE.L #MEGAY,YPEK21+2
   MOVE.W MEGAY,D0
YY21:
 ADDQ.L #2,YPEK21+2
 ADD.W D0,A1
   MOVE.W D0,(A4)+
 MOVEQ #0,D0
XPEK21:
 MOVE.B MEGAX+80,D0           ;X COORD
 BNE.S XX21
   MOVE.L #MEGAX,XPEK21+2
   MOVE.B MEGAX,D0
XX21:
 ADDQ.L #1,XPEK21+2
   MOVE.W D0,(A4)+

 MOVE.W D0,D1
 AND.B #240,D0
 LSR.W #1,D0
 ADD.W D0,A1

   MOVE.L A1,(A4)+

 AND.W #15,D1
 LSL.W #5,D1
 LEA MEGADD+8(PC),A2     ;SKIP MASKS
 ADD.W D1,A2


 LEA MEGABGX,A0          ;LEFT TOP LEG EDGE
 ADD.W A3,A0
 ADD.L (A2),A0           ;OFFSET
N@=0
L@=0
 REPEAT
   MOVEM.L (A0)+,D0-D7
   MOVEM.L D0-D1,L@(A1)
   MOVEM.L D2-D3,L@+160(A1)
   MOVEM.L D4-D5,L@+320(A1)
   MOVEM.L D6-D7,L@+480(A1)

   MOVEM.L D0-D1,L@+16*160(A1)
   MOVEM.L D2-D3,L@+16*160+160(A1)
   MOVEM.L D4-D5,L@+16*160+320(A1)
   MOVEM.L D6-D7,L@+16*160+480(A1)

   MOVEM.L D0-D1,L@+32*160(A1)
   MOVEM.L D2-D3,L@+32*160+160(A1)
   MOVEM.L D4-D5,L@+32*160+320(A1)
   MOVEM.L D6-D7,L@+32*160+480(A1)

   MOVEM.L D0-D1,L@+48*160(A1)
   MOVEM.L D2-D3,L@+48*160+160(A1)
   MOVEM.L D4-D5,L@+48*160+320(A1)
   MOVEM.L D6-D7,L@+48*160+480(A1)

   MOVEM.L D0-D1,L@+64*160(A1)
   MOVEM.L D2-D3,L@+64*160+160(A1)
   MOVEM.L D4-D5,L@+64*160+320(A1)
   MOVEM.L D6-D7,L@+64*160+480(A1)
L@=L@+640
N@=N@+1
 UNTILEQ N@,4

 LEA MEGABGX+(4096*4),A0           ;LEFT BOTTOM LEG EDGE
 ADD.W A3,A0
 ADD.L (A2)+,A0           ;OFFSET
N@=0
L@=80*160
 REPEAT
   MOVEM.L (A0)+,D0-D7
   MOVEM.L D0-D1,L@(A1)
   MOVEM.L D2-D3,L@+160(A1)
   MOVEM.L D4-D5,L@+320(A1)
   MOVEM.L D6-D7,L@+480(A1)

   MOVEM.L D0-D1,L@+16*160(A1)
   MOVEM.L D2-D3,L@+16*160+160(A1)
   MOVEM.L D4-D5,L@+16*160+320(A1)
   MOVEM.L D6-D7,L@+16*160+480(A1)

   MOVEM.L D0-D1,L@+32*160(A1)
   MOVEM.L D2-D3,L@+32*160+160(A1)
   MOVEM.L D4-D5,L@+32*160+320(A1)
   MOVEM.L D6-D7,L@+32*160+480(A1)

   MOVEM.L D0-D1,L@+48*160(A1)
   MOVEM.L D2-D3,L@+48*160+160(A1)
   MOVEM.L D4-D5,L@+48*160+320(A1)
   MOVEM.L D6-D7,L@+48*160+480(A1)

   MOVEM.L D0-D1,L@+64*160(A1)
   MOVEM.L D2-D3,L@+64*160+160(A1)
   MOVEM.L D4-D5,L@+64*160+320(A1)
   MOVEM.L D6-D7,L@+64*160+480(A1)

   MOVEM.L D0-D1,L@+80*160(A1)
   MOVEM.L D2-D3,L@+80*160+160(A1)
   MOVEM.L D4-D5,L@+80*160+320(A1)
   MOVEM.L D6-D7,L@+80*160+480(A1)
L@=L@+640
N@=N@+1
 UNTILEQ N@,4



 LEA MEGABGX+2048,A0           ;RIGHT LEG EDGE 1
 ADD.W A3,A0
 ADD.L (A2),A0                   ;OFFSET
N@=0
L@=7*8
 REPEAT
   MOVEM.L (A0)+,D0-D7
   MOVEM.L D0-D1,L@(A1)
   MOVEM.L D2-D3,L@+160(A1)
   MOVEM.L D4-D5,L@+320(A1)
   MOVEM.L D6-D7,L@+480(A1)

   MOVEM.L D0-D1,L@+16*160(A1)
   MOVEM.L D2-D3,L@+16*160+160(A1)
   MOVEM.L D4-D5,L@+16*160+320(A1)
   MOVEM.L D6-D7,L@+16*160+480(A1)

   MOVEM.L D0-D1,L@+32*160(A1)
   MOVEM.L D2-D3,L@+32*160+160(A1)
   MOVEM.L D4-D5,L@+32*160+320(A1)
   MOVEM.L D6-D7,L@+32*160+480(A1)
L@=L@+640
N@=N@+1
 UNTILEQ N@,4


 LEA MEGABGX+2048,A0           ;RIGHT LEG EDGE 2
 ADD.W A3,A0
 ADD.L (A2),A0                   ;OFFSET
N@=0
L@=48*160+3*8
 REPEAT
   MOVEM.L (A0)+,D0-D7
   MOVEM.L D0-D1,L@(A1)
   MOVEM.L D2-D3,L@+160(A1)
   MOVEM.L D4-D5,L@+320(A1)
   MOVEM.L D6-D7,L@+480(A1)

   MOVEM.L D0-D1,L@+16*160(A1)
   MOVEM.L D2-D3,L@+16*160+160(A1)
   MOVEM.L D4-D5,L@+16*160+320(A1)
   MOVEM.L D6-D7,L@+16*160+480(A1)
L@=L@+640
N@=N@+1
 UNTILEQ N@,4


 LEA MEGABGX+(4096*4)+2048,A0           ;RIGHT LEG EDGE 3
 ADD.W A3,A0
 ADD.L (A2),A0                   ;OFFSET
N@=0
L@=80*160+6*8
 REPEAT
   MOVEM.L (A0)+,D0-D7
   MOVEM.L D0-D1,L@(A1)
   MOVEM.L D2-D3,L@+160(A1)
   MOVEM.L D4-D5,L@+320(A1)
   MOVEM.L D6-D7,L@+480(A1)

   MOVEM.L D0-D1,L@+16*160(A1)
   MOVEM.L D2-D3,L@+16*160+160(A1)
   MOVEM.L D4-D5,L@+16*160+320(A1)
   MOVEM.L D6-D7,L@+16*160+480(A1)

   MOVEM.L D0-D1,L@+32*160(A1)
   MOVEM.L D2-D3,L@+32*160+160(A1)
   MOVEM.L D4-D5,L@+32*160+320(A1)
   MOVEM.L D6-D7,L@+32*160+480(A1)
L@=L@+640
N@=N@+1
 UNTILEQ N@,4


 LEA MEGABGX+(4096*4)+2048,A0           ;RIGHT LEG EDGE 4
 ADD.W A3,A0
 ADD.L (A2)+,A0                  ;OFFSET
N@=0
L@=128*160+3*8
 REPEAT
   MOVEM.L (A0)+,D0-D7
   MOVEM.L D0-D1,L@(A1)
   MOVEM.L D2-D3,L@+160(A1)
   MOVEM.L D4-D5,L@+320(A1)
   MOVEM.L D6-D7,L@+480(A1)

   MOVEM.L D0-D1,L@+16*160(A1)
   MOVEM.L D2-D3,L@+16*160+160(A1)
   MOVEM.L D4-D5,L@+16*160+320(A1)
   MOVEM.L D6-D7,L@+16*160+480(A1)

   MOVEM.L D0-D1,L@+32*160(A1)
   MOVEM.L D2-D3,L@+32*160+160(A1)
   MOVEM.L D4-D5,L@+32*160+320(A1)
   MOVEM.L D6-D7,L@+32*160+480(A1)
L@=L@+640
N@=N@+1
 UNTILEQ N@,4


 LEA MEGAGX,A0            ;GRAFIX. CREATE TOPLEG
 ADD.W A3,A0
 ADD.L (A2),A0            ;OFFSET
L@=8
N@=0
 REPEAT
   MOVEM.L (A0)+,D0-D7
   MOVEM.L D0-D3,L@(A1)
   MOVEM.L D4-D7,L@+160(A1)
   MOVEM.L D0-D3,L@+16(A1)
   MOVEM.L D4-D7,L@+16+160(A1)
   MOVEM.L D0-D3,L@+32(A1)
   MOVEM.L D4-D7,L@+32+160(A1)

   MOVEM.L D0-D3,L@+16*160(A1)
   MOVEM.L D4-D7,L@+16*160+160(A1)
   MOVEM.L D0-D3,L@+16*160+16(A1)
   MOVEM.L D4-D7,L@+16*160+16+160(A1)
   MOVEM.L D0-D3,L@+16*160+32(A1)
   MOVEM.L D4-D7,L@+16*160+32+160(A1)

   MOVEM.L D0-D3,L@+32*160(A1)
   MOVEM.L D4-D7,L@+32*160+160(A1)
   MOVEM.L D0-D3,L@+32*160+16(A1)
   MOVEM.L D4-D7,L@+32*160+16+160(A1)
   MOVEM.L D0-D3,L@+32*160+32(A1)
   MOVEM.L D4-D7,L@+32*160+32+160(A1)

   MOVEM.L D0-D3,L@+48*160(A1)
   MOVEM.L D4-D7,L@+48*160+160(A1)

   MOVEM.L D0-D3,L@+64*160(A1)
   MOVEM.L D4-D7,L@+64*160+160(A1)
N@=N@+1
L@=L@+320
 UNTILEQ N@,8


 LEA MEGAGX+(256*64),A0         ;GRAFIX. BOTTOM LEG
 ADD.W A3,A0
 ADD.L (A2)+,A0                  ;OFFSET
L@=160*80+8
N@=0
 REPEAT
   MOVEM.L (A0)+,D0-D7
   MOVEM.L D0-D3,L@(A1)
   MOVEM.L D4-D7,L@+160(A1)
   MOVEM.L D0-D3,L@+16(A1)
   MOVEM.L D4-D7,L@+16+160(A1)
   MOVEM.L D0-D1,L@+32(A1)
   MOVEM.L D4-D5,L@+32+160(A1)

   MOVEM.L D0-D3,L@+16*160(A1)
   MOVEM.L D4-D7,L@+16*160+160(A1)
   MOVEM.L D0-D3,L@+16*160+16(A1)
   MOVEM.L D4-D7,L@+16*160+16+160(A1)
   MOVEM.L D0-D1,L@+32+16*160(A1)
   MOVEM.L D4-D5,L@+32+17*160(A1)

   MOVEM.L D0-D3,L@+32*160(A1)
   MOVEM.L D4-D7,L@+32*160+160(A1)
   MOVEM.L D0-D3,L@+32*160+16(A1)
   MOVEM.L D4-D7,L@+32*160+16+160(A1)
   MOVEM.L D0-D1,L@+32+32*160(A1)
   MOVEM.L D4-D5,L@+32+33*160(A1)

   MOVEM.L D0-D3,L@+48*160(A1)
   MOVEM.L D4-D7,L@+48*160+160(A1)

   MOVEM.L D0-D3,L@+64*160(A1)
   MOVEM.L D4-D7,L@+64*160+160(A1)

   MOVEM.L D0-D3,L@+80*160(A1)
   MOVEM.L D4-D7,L@+80*160+160(A1)
N@=N@+1
L@=L@+320
 UNTILEQ N@,8

 RTS



MEGADD2:
 DC.W 0,0,0,0,4096,4096,4096,4096,8192,8192,8192,8192,12288,12288,12288,12288
 DC.W 8192,8192,8192,8192,4096,4096,4096,4096
 DC.W -1
MEGADD:  ;LEFT MASK, RIGHT MASK, LEFTBGX, RIGHTBGX, GXOFFS, DUMMY*3
 DC.L $00000000,$FFFFFFFF,0,1920, 0,0,0,0
 DC.L $80008000,$7FFF7FFF,128,1792, 256,0,0,0
 DC.L $C000C000,$3FFF3FFF,256,1664, 512,0,0,0
 DC.L $E000E000,$1FFF1FFF,384,1536, 768,0,0,0
 DC.L $F000F000,$0FFF0FFF,512,1408, 1024,0,0,0
 DC.L $F800F800,$07FF07FF,640,1280, 1280,0,0,0
 DC.L $FC00FC00,$03FF03FF,768,1152, 1536,0,0,0
 DC.L $FE00FE00,$01FF01FF,896,1024, 1792,0,0,0
 DC.L $FF00FF00,$00FF00FF,1024,896, 2048,0,0,0
 DC.L $FF80FF80,$007F007F,1152,768, 2304,0,0,0
 DC.L $FFC0FFC0,$003F003F,1280,640, 2560,0,0,0
 DC.L $FFE0FFE0,$001F001F,1408,512, 2816,0,0,0
 DC.L $FFF0FFF0,$000F000F,1536,384, 3072,0,0,0
 DC.L $FFF8FFF8,$00070007,1664,256, 3328,0,0,0
 DC.L $FFFCFFFC,$00030003,1792,128, 3584,0,0,0
 DC.L $FFFEFFFE,$00010001,1920,0, 3840,0,0,0

MEGAFF:   ;PEK!
 LEA MEGADD2,A0
 LEA 0,A3
 MOVE.W (A0)+,A3
 CMP.W #-1,A3
 BNE.S YY2
   LEA MEGADD2(PC),A0
   MOVE.W (A0)+,A3
YY2:
 MOVE.L A0,MEGAFF+2

   LEA BTAB(PC),A4
   BTST #0,CLOCK+1
   BEQ.S YY3
     ADDQ.W #8,A4
YY3:

 MOVE.L SCREENS(PC),A1
YPEK1:
 MOVE.W MEGAY,D0           ;Y COORD
 BNE.S YY1
   MOVE.L #MEGAY,YPEK1+2
   MOVE.W MEGAY(PC),D0
YY1:
 ADDQ.L #2,YPEK1+2
 ADD.W D0,A1
   MOVE.W D0,(A4)+
 MOVEQ #0,D0
XPEK1:
 MOVE.B MEGAX,D0           ;X COORD
 BNE.S XX1
   MOVE.L #MEGAX,XPEK1+2
   MOVE.B MEGAX(PC),D0
XX1:
 ADDQ.L #1,XPEK1+2
   MOVE.W D0,(A4)+

 MOVE.W D0,D1
 AND.B #240,D0
 LSR.W #1,D0
 ADD.W D0,A1

   MOVE.L A1,(A4)+

 AND.W #15,D1
 LSL.W #5,D1
 LEA MEGADD(PC),A2
 ADD.W D1,A2


 MOVEQ #0,D1
 MOVE.L (A2)+,D0          ;LEFT MASK
N@=0                      ;MASK LEFT 'F' LEG
L@=0
 REPEAT
   AND.L D0,L@(A1)
   AND.L D0,L@+4(A1)
L@=L@+160
N@=N@+1
 UNTILEQ N@,176


 MOVE.L (A2)+,D0          ;RIGHT MASK
N@=0                      ;MASK RIGHT 'F' LEG
L@=7*8
 REPEAT
   AND.L D0,L@(A1)
   AND.L D0,L@+4(A1)
L@=L@+160
N@=N@+1
 UNTILEQ N@,48
N@=0
L@=3*8+(160*48)
 REPEAT
   AND.L D0,L@(A1)
   AND.L D0,L@+4(A1)
L@=L@+160
N@=N@+1
 UNTILEQ N@,32
N@=0
L@=6*8+(160*80)
 REPEAT
   AND.L D0,L@(A1)
   AND.L D0,L@+4(A1)
L@=L@+160
N@=N@+1
 UNTILEQ N@,48
N@=0
L@=3*8+(160*128)
 REPEAT
   AND.L D0,L@(A1)
   AND.L D0,L@+4(A1)
L@=L@+160
N@=N@+1
 UNTILEQ N@,48


 LEA MEGABGX,A0          ;LEFT TOP LEG EDGE
 ADD.W A3,A0
 ADD.L (A2),A0           ;OFFSET
N@=0
L@=0
 REPEAT
   MOVEM.L (A0)+,D0-D7
   OR.L D0,L@(A1)
   OR.L D1,L@+4(A1)
   OR.L D2,L@+160(A1)
   OR.L D3,L@+164(A1)
   OR.L D4,L@+320(A1)
   OR.L D5,L@+324(A1)
   OR.L D6,L@+480(A1)
   OR.L D7,L@+484(A1)

   OR.L D0,L@+16*160(A1)
   OR.L D1,L@+16*160+4(A1)
   OR.L D2,L@+16*160+160(A1)
   OR.L D3,L@+16*160+164(A1)
   OR.L D4,L@+16*160+320(A1)
   OR.L D5,L@+16*160+324(A1)
   OR.L D6,L@+16*160+480(A1)
   OR.L D7,L@+16*160+484(A1)

   OR.L D0,L@+32*160(A1)
   OR.L D1,L@+32*160+4(A1)
   OR.L D2,L@+32*160+160(A1)
   OR.L D3,L@+32*160+164(A1)
   OR.L D4,L@+32*160+320(A1)
   OR.L D5,L@+32*160+324(A1)
   OR.L D6,L@+32*160+480(A1)
   OR.L D7,L@+32*160+484(A1)

   OR.L D0,L@+48*160(A1)
   OR.L D1,L@+48*160+4(A1)
   OR.L D2,L@+48*160+160(A1)
   OR.L D3,L@+48*160+164(A1)
   OR.L D4,L@+48*160+320(A1)
   OR.L D5,L@+48*160+324(A1)
   OR.L D6,L@+48*160+480(A1)
   OR.L D7,L@+48*160+484(A1)

   OR.L D0,L@+64*160(A1)
   OR.L D1,L@+64*160+4(A1)
   OR.L D2,L@+64*160+160(A1)
   OR.L D3,L@+64*160+164(A1)
   OR.L D4,L@+64*160+320(A1)
   OR.L D5,L@+64*160+324(A1)
   OR.L D6,L@+64*160+480(A1)
   OR.L D7,L@+64*160+484(A1)
L@=L@+640
N@=N@+1
 UNTILEQ N@,4

 LEA MEGABGX+(4096*4),A0           ;LEFT BOTTOM LEG EDGE
 ADD.W A3,A0
 ADD.L (A2)+,A0           ;OFFSET
N@=0
L@=80*160
 REPEAT
   MOVEM.L (A0)+,D0-D7
   OR.L D0,L@(A1)
   OR.L D1,L@+4(A1)
   OR.L D2,L@+160(A1)
   OR.L D3,L@+164(A1)
   OR.L D4,L@+320(A1)
   OR.L D5,L@+324(A1)
   OR.L D6,L@+480(A1)
   OR.L D7,L@+484(A1)

   OR.L D0,L@+16*160(A1)
   OR.L D1,L@+16*160+4(A1)
   OR.L D2,L@+16*160+160(A1)
   OR.L D3,L@+16*160+164(A1)
   OR.L D4,L@+16*160+320(A1)
   OR.L D5,L@+16*160+324(A1)
   OR.L D6,L@+16*160+480(A1)
   OR.L D7,L@+16*160+484(A1)

   OR.L D0,L@+32*160(A1)
   OR.L D1,L@+32*160+4(A1)
   OR.L D2,L@+32*160+160(A1)
   OR.L D3,L@+32*160+164(A1)
   OR.L D4,L@+32*160+320(A1)
   OR.L D5,L@+32*160+324(A1)
   OR.L D6,L@+32*160+480(A1)
   OR.L D7,L@+32*160+484(A1)

   OR.L D0,L@+48*160(A1)
   OR.L D1,L@+48*160+4(A1)
   OR.L D2,L@+48*160+160(A1)
   OR.L D3,L@+48*160+164(A1)
   OR.L D4,L@+48*160+320(A1)
   OR.L D5,L@+48*160+324(A1)
   OR.L D6,L@+48*160+480(A1)
   OR.L D7,L@+48*160+484(A1)

   OR.L D0,L@+64*160(A1)
   OR.L D1,L@+64*160+4(A1)
   OR.L D2,L@+64*160+160(A1)
   OR.L D3,L@+64*160+164(A1)
   OR.L D4,L@+64*160+320(A1)
   OR.L D5,L@+64*160+324(A1)
   OR.L D6,L@+64*160+480(A1)
   OR.L D7,L@+64*160+484(A1)

   OR.L D0,L@+80*160(A1)
   OR.L D1,L@+80*160+4(A1)
   OR.L D2,L@+80*160+160(A1)
   OR.L D3,L@+80*160+164(A1)
   OR.L D4,L@+80*160+320(A1)
   OR.L D5,L@+80*160+324(A1)
   OR.L D6,L@+80*160+480(A1)
   OR.L D7,L@+80*160+484(A1)
L@=L@+640
N@=N@+1
 UNTILEQ N@,4



 LEA MEGABGX+2048,A0           ;RIGHT LEG EDGE 1
 ADD.W A3,A0
 ADD.L (A2),A0                   ;OFFSET
N@=0
L@=7*8
 REPEAT
   MOVEM.L (A0)+,D0-D7
   OR.L D0,L@(A1)
   OR.L D1,L@+4(A1)
   OR.L D2,L@+160(A1)
   OR.L D3,L@+164(A1)
   OR.L D4,L@+320(A1)
   OR.L D5,L@+324(A1)
   OR.L D6,L@+480(A1)
   OR.L D7,L@+484(A1)

   OR.L D0,L@+16*160(A1)
   OR.L D1,L@+16*160+4(A1)
   OR.L D2,L@+16*160+160(A1)
   OR.L D3,L@+16*160+164(A1)
   OR.L D4,L@+16*160+320(A1)
   OR.L D5,L@+16*160+324(A1)
   OR.L D6,L@+16*160+480(A1)
   OR.L D7,L@+16*160+484(A1)

   OR.L D0,L@+32*160(A1)
   OR.L D1,L@+32*160+4(A1)
   OR.L D2,L@+32*160+160(A1)
   OR.L D3,L@+32*160+164(A1)
   OR.L D4,L@+32*160+320(A1)
   OR.L D5,L@+32*160+324(A1)
   OR.L D6,L@+32*160+480(A1)
   OR.L D7,L@+32*160+484(A1)
L@=L@+640
N@=N@+1
 UNTILEQ N@,4


 LEA MEGABGX+2048,A0           ;RIGHT LEG EDGE 2
 ADD.W A3,A0
 ADD.L (A2),A0                   ;OFFSET
N@=0
L@=48*160+3*8
 REPEAT
   MOVEM.L (A0)+,D0-D7
   OR.L D0,L@(A1)
   OR.L D1,L@+4(A1)
   OR.L D2,L@+160(A1)
   OR.L D3,L@+164(A1)
   OR.L D4,L@+320(A1)
   OR.L D5,L@+324(A1)
   OR.L D6,L@+480(A1)
   OR.L D7,L@+484(A1)

   OR.L D0,L@+16*160(A1)
   OR.L D1,L@+16*160+4(A1)
   OR.L D2,L@+16*160+160(A1)
   OR.L D3,L@+16*160+164(A1)
   OR.L D4,L@+16*160+320(A1)
   OR.L D5,L@+16*160+324(A1)
   OR.L D6,L@+16*160+480(A1)
   OR.L D7,L@+16*160+484(A1)
L@=L@+640
N@=N@+1
 UNTILEQ N@,4


 LEA MEGABGX+(4096*4)+2048,A0           ;RIGHT LEG EDGE 3
 ADD.W A3,A0
 ADD.L (A2),A0                   ;OFFSET
N@=0
L@=80*160+6*8
 REPEAT
   MOVEM.L (A0)+,D0-D7
   OR.L D0,L@(A1)
   OR.L D1,L@+4(A1)
   OR.L D2,L@+160(A1)
   OR.L D3,L@+164(A1)
   OR.L D4,L@+320(A1)
   OR.L D5,L@+324(A1)
   OR.L D6,L@+480(A1)
   OR.L D7,L@+484(A1)

   OR.L D0,L@+16*160(A1)
   OR.L D1,L@+16*160+4(A1)
   OR.L D2,L@+16*160+160(A1)
   OR.L D3,L@+16*160+164(A1)
   OR.L D4,L@+16*160+320(A1)
   OR.L D5,L@+16*160+324(A1)
   OR.L D6,L@+16*160+480(A1)
   OR.L D7,L@+16*160+484(A1)

   OR.L D0,L@+32*160(A1)
   OR.L D1,L@+32*160+4(A1)
   OR.L D2,L@+32*160+160(A1)
   OR.L D3,L@+32*160+164(A1)
   OR.L D4,L@+32*160+320(A1)
   OR.L D5,L@+32*160+324(A1)
   OR.L D6,L@+32*160+480(A1)
   OR.L D7,L@+32*160+484(A1)
L@=L@+640
N@=N@+1
 UNTILEQ N@,4


 LEA MEGABGX+(4096*4)+2048,A0           ;RIGHT LEG EDGE 4
 ADD.W A3,A0
 ADD.L (A2)+,A0                  ;OFFSET
N@=0
L@=128*160+3*8
 REPEAT
   MOVEM.L (A0)+,D0-D7
   OR.L D0,L@(A1)
   OR.L D1,L@+4(A1)
   OR.L D2,L@+160(A1)
   OR.L D3,L@+164(A1)
   OR.L D4,L@+320(A1)
   OR.L D5,L@+324(A1)
   OR.L D6,L@+480(A1)
   OR.L D7,L@+484(A1)

   OR.L D0,L@+16*160(A1)
   OR.L D1,L@+16*160+4(A1)
   OR.L D2,L@+16*160+160(A1)
   OR.L D3,L@+16*160+164(A1)
   OR.L D4,L@+16*160+320(A1)
   OR.L D5,L@+16*160+324(A1)
   OR.L D6,L@+16*160+480(A1)
   OR.L D7,L@+16*160+484(A1)

   OR.L D0,L@+32*160(A1)
   OR.L D1,L@+32*160+4(A1)
   OR.L D2,L@+32*160+160(A1)
   OR.L D3,L@+32*160+164(A1)
   OR.L D4,L@+32*160+320(A1)
   OR.L D5,L@+32*160+324(A1)
   OR.L D6,L@+32*160+480(A1)
   OR.L D7,L@+32*160+484(A1)
L@=L@+640
N@=N@+1
 UNTILEQ N@,4


 LEA MEGAGX,A0            ;GRAFIX. CREATE TOPLEG
 ADD.W A3,A0
 ADD.L (A2),A0            ;OFFSET
L@=8
N@=0
 REPEAT
   MOVEM.L (A0)+,D0-D7
   MOVEM.L D0-D3,L@(A1)
   MOVEM.L D4-D7,L@+160(A1)
   MOVEM.L D0-D3,L@+16(A1)
   MOVEM.L D4-D7,L@+16+160(A1)
   MOVEM.L D0-D3,L@+32(A1)
   MOVEM.L D4-D7,L@+32+160(A1)

   MOVEM.L D0-D3,L@+16*160(A1)
   MOVEM.L D4-D7,L@+16*160+160(A1)
   MOVEM.L D0-D3,L@+16*160+16(A1)
   MOVEM.L D4-D7,L@+16*160+16+160(A1)
   MOVEM.L D0-D3,L@+16*160+32(A1)
   MOVEM.L D4-D7,L@+16*160+32+160(A1)

   MOVEM.L D0-D3,L@+32*160(A1)
   MOVEM.L D4-D7,L@+32*160+160(A1)
   MOVEM.L D0-D3,L@+32*160+16(A1)
   MOVEM.L D4-D7,L@+32*160+16+160(A1)
   MOVEM.L D0-D3,L@+32*160+32(A1)
   MOVEM.L D4-D7,L@+32*160+32+160(A1)

   MOVEM.L D0-D3,L@+48*160(A1)
   MOVEM.L D4-D7,L@+48*160+160(A1)

   MOVEM.L D0-D3,L@+64*160(A1)
   MOVEM.L D4-D7,L@+64*160+160(A1)
N@=N@+1
L@=L@+320
 UNTILEQ N@,8


 LEA MEGAGX+(256*64),A0         ;GRAFIX. BOTTOM LEG
 ADD.W A3,A0
 ADD.L (A2)+,A0                  ;OFFSET
L@=160*80+8
N@=0
 REPEAT
   MOVEM.L (A0)+,D0-D7
   MOVEM.L D0-D3,L@(A1)
   MOVEM.L D4-D7,L@+160(A1)
   MOVEM.L D0-D3,L@+16(A1)
   MOVEM.L D4-D7,L@+16+160(A1)
   MOVEM.L D0-D1,L@+32(A1)
   MOVEM.L D4-D5,L@+32+160(A1)

   MOVEM.L D0-D3,L@+16*160(A1)
   MOVEM.L D4-D7,L@+16*160+160(A1)
   MOVEM.L D0-D3,L@+16*160+16(A1)
   MOVEM.L D4-D7,L@+16*160+16+160(A1)
   MOVEM.L D0-D1,L@+32+16*160(A1)
   MOVEM.L D4-D5,L@+32+17*160(A1)

   MOVEM.L D0-D3,L@+32*160(A1)
   MOVEM.L D4-D7,L@+32*160+160(A1)
   MOVEM.L D0-D3,L@+32*160+16(A1)
   MOVEM.L D4-D7,L@+32*160+16+160(A1)
   MOVEM.L D0-D1,L@+32+32*160(A1)
   MOVEM.L D4-D5,L@+32+33*160(A1)

   MOVEM.L D0-D3,L@+48*160(A1)
   MOVEM.L D4-D7,L@+48*160+160(A1)

   MOVEM.L D0-D3,L@+64*160(A1)
   MOVEM.L D4-D7,L@+64*160+160(A1)

   MOVEM.L D0-D3,L@+80*160(A1)
   MOVEM.L D4-D7,L@+80*160+160(A1)
N@=N@+1
L@=L@+320
 UNTILEQ N@,8

 RTS

BTAB: DC.L 0,SCR1,0,SCR1
BLACKFF:
   LEA BTAB(PC),A1
   LEA 8(A1),A2
   BTST #0,CLOCK+1
   BEQ.S BFF1
     EXG.L A1,A2
BFF1:
 MOVEQ #0,D0
 MOVEQ #0,D1
 MOVEQ #0,D2
 MOVEQ #0,D3
 MOVEQ #0,D4
 MOVEQ #0,D5
 MOVEQ #0,D6
 MOVEQ #0,D7

 MOVE.L 4(A1),A0     ;SCREEN ADDRESS TO BLACKOUT
 CMPM.W (A1)+,(A2)+  ;COMPARE Y COORDS
 BGE.S BFF2
   BSR BLACKDOWN
   BRA.S BFF3
BFF2:
   BSR BLACKUP
BFF3:

 CMPM.W (A1)+,(A2)+  ;COMPARE X COORDS
 BEQ.S BUFFSPEC
 BGT.S BFF4
BFF34:
   BSR BLACKRIGHT
   BRA.S BFF5
BFF4:
 BSR BLACKLEFT
BFF5:
 RTS
BUFFSPEC:
   MOVE.L XPEK1+2,A3
BFS1:
   SUBQ.W #1,A1
   CMPM.B (A1)+,(A3)+
   BEQ.S BFS1
   BGT.S BFF4
     BSR BLACKRIGHT
 BRA.S BFF5

BTAB2: DC.L 0,SCR1,0,SCR1
BLACKFF2:
   LEA BTAB2(PC),A1
   LEA 8(A1),A2
   BTST #0,CLOCK+1
   BEQ.S BFF21
     EXG.L A1,A2
BFF21:
 MOVEQ #0,D0
 MOVEQ #0,D1
 MOVEQ #0,D2
 MOVEQ #0,D3
 MOVEQ #0,D4
 MOVEQ #0,D5
 MOVEQ #0,D6
 MOVEQ #0,D7

 MOVE.L 4(A1),A0     ;SCREEN ADDRESS TO BLACKOUT
 CMPM.W (A1)+,(A2)+  ;COMPARE Y COORDS
 BGE.S BFF22
   BSR BLACKDOWN
   BRA.S BFF23
BFF22:
   BSR BLACKUP
BFF23:

 CMPM.W (A1)+,(A2)+  ;COMPARE X COORDS
; BEQ.S BFF26
 BGT.S BFF24
   BSR BLACKRIGHT2
   BRA.S BFF25
BFF24:
   BSR BLACKLEFT2
BFF25:
 RTS
;BFF26:
; CMP.W #25,-2(A2)
; BLE.S BFF24
; BSR BLACKRIGHT2
; RTS


BLACKLEFT:
N@=0
L@=0
 REPEAT
   MOVEM.L D0-D3,L@(A0)
L@=L@+160
N@=N@+1
 UNTILEQ N@,176
 RTS

BLACKLEFT2:
N@=0
L@=0
 REPEAT
   MOVE.L D0,L@(A0)
   MOVE.L D0,L@+4(A0)
L@=L@+160
N@=N@+1
 UNTILEQ N@,176
 RTS

BLACKRIGHT:
N@=0
L@=64-16
 REPEAT
   MOVEM.L D0-D3,L@(A0)
L@=L@+160
N@=N@+1
 UNTILEQ N@,48

N@=0
L@=(48*160)+32-16
 REPEAT
   MOVEM.L D0-D3,L@(A0)
L@=L@+160
N@=N@+1
 UNTILEQ N@,32

N@=0
L@=(80*160)+56-16
 REPEAT
   MOVEM.L D0-D3,L@(A0)
L@=L@+160
N@=N@+1
 UNTILEQ N@,48

N@=0
L@=(128*160)+32-16
 REPEAT
   MOVEM.L D0-D3,L@(A0)
L@=L@+160
N@=N@+1
 UNTILEQ N@,48
 RTS


BLACKRIGHT2:
N@=0
L@=64-8
 REPEAT
   MOVE.L D0,L@(A0)
   MOVE.L D0,L@+4(A0)
L@=L@+160
N@=N@+1
 UNTILEQ N@,48

N@=0
L@=(48*160)+32-8
 REPEAT
   MOVE.L D0,L@(A0)
   MOVE.L D0,L@+4(A0)
L@=L@+160
N@=N@+1
 UNTILEQ N@,32

N@=0
L@=(80*160)+56-8
 REPEAT
   MOVE.L D0,L@(A0)
   MOVE.L D0,L@+4(A0)
L@=L@+160
N@=N@+1
 UNTILEQ N@,48

N@=0
L@=(128*160)+32-8
 REPEAT
   MOVE.L D0,L@(A0)
   MOVE.L D0,L@+4(A0)
L@=L@+160
N@=N@+1
 UNTILEQ N@,48
 RTS



BLACKDOWN:
N@=0
L@=(44*160)+24
 REPEAT
   MOVEM.L D0-D7,L@(A0)
   MOVEM.L D0-D1,L@+32(A0)
L@=L@+160
N@=N@+1
 UNTILEQ N@,5

N@=0
L@=(124*160)+24
 REPEAT
   MOVEM.L D0-D7,L@(A0)
L@=L@+160
N@=N@+1
 UNTILEQ N@,5

N@=0
L@=(172*160)
 REPEAT
   MOVEM.L D0-D7,L@(A0)
L@=L@+160
N@=N@+1
 UNTILEQ N@,5
 RTS


BLACKUP:
N@=0
L@=0
 REPEAT
   MOVEM.L D0-D7,L@(A0)
   MOVEM.L D0-D7,L@+32(A0)
L@=L@+160
N@=N@+1
 UNTILEQ N@,4

N@=0
L@=80*160+24
 REPEAT
   MOVEM.L D0-D7,L@(A0)
L@=L@+160
N@=N@+1
 UNTILEQ N@,4
 RTS



START:
 CLR.L -(SP)
 MOVE.W #$20,-(SP)
 TRAP #1
 ADDQ.L #6,SP
 MOVE.L D0,SPAR+4

 MOVE.W #0,$484

 PEA MOUSE
 MOVE.W #1,-(SP)
 MOVE.W #25,-(SP)
 TRAP #14
 ADDQ.L #8,SP

 CLR.W -(SP)     ;SETSCR
 PEA SCR1
 PEA SCR1
 MOVE.W #5,-(SP)
 TRAP #14
 ADD.L #12,SP

 LEA $FF8240,A0
 LEA OPAL,A1
 MOVEQ #7,D0
 BSR COPY
 LEA PAL,A0
 LEA $FF8240,A1
 MOVEQ #7,D0
 BSR COPY

 BSR FIXGRAF
 BSR FIXBGRAF
 BSR MAKEREFLEX
 BSR MAKESCROLL

 LEA SCR1,A0
 MOVEQ #0,D1
 MOVE.W #7999,D0
CLS:
 MOVE.L D1,(A0)+
 MOVE.L D1,(A0)+
 DBRA D0,CLS

; LEA SCR1+152,A0
; LEA SCR2+152,A1
; MOVE.L #$00FF00FF,D1
; MOVE.W #199,D0
;MAKEBACK:
; MOVE.L D1,(A0)
; MOVE.L D1,(A1)
; ADD.W #160,A0
; ADD.W #160,A1
; DBRA D0,MAKEBACK


 MOVEQ #1,D0
 JSR MUSIC+$30
 MOVE.W #$2700,SR
 MOVE.L $70,OVBL
 BSR INITRAST
 MOVE.L #VBL,$70
 MOVE.W #$2300,SR
 JMP MAIN

EXIT:
 MOVE.W #$2700,SR
FLUSH:
 BTST #0,$FFFC00          ;IS A CHARACTER WAITING ?
 BEQ.S FL1                ;BR. IF NOT
 MOVE.B $FFFC02,D0        ;READ CHARACTER (& IGNORE IT)
 BRA.S FLUSH              ;CHECK FOR ANOTHER
FL1:
 BSR REMOVERAST
 MOVE.L OVBL,$70
 MOVE.W #$2300,SR

 IFNE EXEC,-1
   MOVE.W #1,-(SP)
   PEA $F8000
   PEA $F8000
   MOVE.W #5,-(SP)
   TRAP #14
   ADD.L #12,SP
 ENDIF

 LEA OPAL,A0
 LEA $FF8240,A1
 MOVEQ #7,D0
 BSR COPY

 MOVE.L SPAR+4,-(SP)
 MOVE.W #$20,-(SP)
 TRAP #1
 ADDQ.L #6,SP

 PEA MOUSE+2
 MOVE.W #1,-(SP)
 MOVE.W #25,-(SP)
 TRAP #14
 ADDQ.L #8,SP
 IFEQ EXEC,0
   ILLEGAL
 ELSE
   CLR.W -(SP)
   TRAP #1
 ENDIF
COPY:
 MOVE.L (A0)+,(A1)+
 DBRA D0,COPY
 RTS
MFP1:
 DC.W 0

INITRAST:
   LEA COLTAB(PC),A5
   LEA $FF8240,A6
 MOVE.L $120,SPAR2
 MOVE.B $FFFA09,SPAR4
 MOVE.B $FFFA07,SPAR4+1
 MOVE.B $FFFA13,SPAR4+2
 CLR.B $FFFA07
 CLR.B $FFFA09
 MOVE.L #RASTER1,$120
 ORI.B #1,$FFFA07
 ORI.B #1,$FFFA13
 RTS

REMOVERAST:
 MOVE.B SPAR4,$FFFA09
 MOVE.B SPAR4+1,$FFFA07
 MOVE.B SPAR4+2,$FFFA13
 MOVE.L SPAR2,$120
 RTS

RASTER1:
 MOVE.W (A5)+,(A6)
 BCLR #0,$FFFA0F
 RTE

FIXGRAF:
 LEA GRAF(PC),A0
 LEA MEGAGX(PC),A1
 MOVEQ #7,D0         ;NR OF GX BLOCKS
FG5:
   MOVEM.L A0-A1/D0,-(SP)
   BSR FIXONE
   MOVEM.L (SP)+,A0-A1/D0
   ADD.W #128,A0
   ADD.W #16*256,A1
 DBRA D0,FG5
 RTS

FIXONE:
 MOVE.L A1,A2
 MOVEQ #15,D2       ;16 PIXELS HIGH
FG1:
 MOVE.L (A0)+,D0
 MOVE.L (A0)+,D1
 MOVE.L D0,(A1)+
 MOVE.L D1,(A1)+
 MOVE.L D0,(A1)+
 MOVE.L D1,(A1)+
 DBRA D2,FG1

 LEA 256(A2),A3
 MOVEQ #14,D3      ;15 ROTATIONS
FG4:
 MOVE.L A2,A0
 MOVE.L A3,A1
 MOVEQ #63,D0
 BSR COPY

 MOVE.L A3,A0
 MOVEQ #15,D1   ;16 PIXELS
FG3:
   MOVEQ #3,D0    ;4 BITPLANES
FG2:
   MOVEQ #0,D2
   MOVE #0,CCR
   ROXR.W (A0)
   ROXR.W 8(A0)
   ROXR.W #1,D2
   OR.W D2,(A0)+
   DBRA D0,FG2
 ADDQ.W #8,A0     ;16-8
 DBRA D1,FG3
 MOVE.L A3,A2
 LEA 256(A3),A3
 DBRA D3,FG4

 RTS



FIXBGRAF:
 LEA GRAF(PC),A2
 LEA MEGABGX,A3
 MOVEQ #7,D0
FXB4:
 MOVEM.L A2-A3/D0,-(SP)
 BSR FIXONEB
 MOVEM.L (SP)+,A2-A3/D0
 LEA 128(A2),A2
 LEA 4096(A3),A3
 DBRA D0,FXB4
 RTS
FIXONEB:
 MOVE.L A2,A0      ;LEFT
 MOVE.L A3,A1
 MOVEQ #31,D0
 BSR COPY

 MOVE.L A2,A0      ;RIGHT
 LEA 2048-128(A3),A1
 MOVEQ #31,D0
 BSR COPY

 MOVE.L A3,A2
 LEA 128(A3),A3

 MOVEQ #14,D1    ;15 ROTATIONS
FGB2:
   MOVE.L A2,A0
   MOVE.L A3,A1
   MOVEQ #31,D0
   BSR COPY

   LEA 2048-128(A2),A0
   LEA 2048-128(A3),A1
   MOVEQ #31,D0
   BSR COPY

   MOVE.L A3,A0
   MOVE.W #4*16-1,D0
FGB1:
   MOVE #0,CCR
   ROXR.W (A0)+
   DBRA D0,FGB1

   LEA 2048-128(A3),A0
   MOVE.W #4*16-1,D0
FGB3:
   MOVE #0,CCR
   ROXL.W (A0)+
   DBRA D0,FGB3

 MOVE.L A3,A2
 LEA 128(A3),A3
 DBRA D1,FGB2

 LEA 2048-128(A3),A0
 MOVEQ #128/4-1,D0
FGB6:
 CLR.L (A0)+
 DBRA D0,FGB6
 RTS


MAKESCROLL:
 LEA ASCII(PC),A0
 LEA SCROLLER,A1
 LEA SYSFONT(PC),A2
MSC2:
 CLR.W D0
 MOVE.B (A0)+,D0
 BEQ.S MSC1
   SUB.B #32,D0
   LSL.W #3,D0
   MOVE.L (A2,D0.W),(A1)+
   MOVE.L 4(A2,D0.W),(A1)+
   BRA.S MSC2
MSC1:
 RTS


MAKEREFLEX:
 LEA REFLEXDAT(PC),A0
 LEA REFGRAF,A1
 MOVEQ #31,D7
MRX1:
 MOVEM.L (A0)+,D0-D6
 MOVEM.L D0-D6,(A1)
 MOVEM.L (A0)+,D0-D6
 MOVEM.L D0-D6,28(A1)
 ADD.W #56,A1
 CLR.L (A1)+
 CLR.L (A1)+
 DBRA D7,MRX1


 LEA REFGRAF,A2
 LEA REFGRAF+2048,A3
 MOVEQ #14,D1   ;15 COPIES & ROTATIONS
MRX2:
 MOVE.L A2,A0
 MOVE.L A3,A1
 MOVE.W #2048/4-1,D0
 BSR COPY
 MOVEQ #31,D2   ;32 PIXELS HIGH
MRX4:
 MOVEQ #3,D0    ;4 BITPLANES
MRX3:
   MOVE #0,CCR
   ROXR.W (A3)
   ROXR.W 8(A3)
   ROXR.W 16(A3)
   ROXR.W 24(A3)
   ROXR.W 32(A3)
   ROXR.W 40(A3)
   ROXR.W 48(A3)
   ROXR.W 56(A3)
   ADDQ.W #2,A3
 DBRA D0,MRX3
 ADD.W #56,A3
 DBRA D2,MRX4
 LEA 2048(A2),A2
 LEA 2048(A2),A3
 DBRA D1,MRX2

 LEA REFGRAF,A0       ;MAKE MASK
 LEA REFGRAF+32768,A1
 MOVE.W #4095,D1
MRX5:
 MOVE.W (A0)+,D0
 OR.W (A0)+,D0
 OR.W (A0)+,D0
 OR.W (A0)+,D0
 NOT.W D0
 MOVE.W D0,(A1)+
 MOVE.W D0,(A1)+
 DBRA D1,MRX5
 RTS


OKEY: DC.L 0,0
OHBL: DC.L 0
SPAR: DS.L 8,0
SPAR1: DC.L 0
SPAR2: DC.L 0
SPAR3: DC.L 0
SPAR4: DC.L 0
SPAR5: DC.W 0
OMFP:
 DC.W 0
PAL:
 DC.W $000,$700,$710,$720,$730,$740,$750,$760
 DC.W $007,$017,$027,$037,$047,$057,$067,$077
OPAL:
 DS.W 16,0
OVBL:
 DC.L 0

COLTAB:
;N@=0
; REPEAT
 DC.W $000,$000,$000
 DC.W $001,$110,$100
 DC.W $002,$220,$200
 DC.W $003,$330,$300
 DC.W $004,$440,$400
 DC.W $005,$550,$500
 DC.W $006,$660,$600
 DC.W $007,$770,$700
 DC.W $007,$770,$700
 DC.W $006,$660,$600
 DC.W $005,$550,$500
 DC.W $004,$440,$400
 DC.W $003,$330,$300
 DC.W $002,$220,$200
 DC.W $001,$110,$100
 DC.W $000,$000,$000

 DC.W 0,0

 DC.W $000,$000,$000
 DC.W $110,$001,$010
 DC.W $220,$002,$020
 DC.W $330,$003,$030
 DC.W $440,$004,$040
 DC.W $550,$005,$050
 DC.W $660,$006,$060
 DC.W $770,$007,$070
 DC.W $770,$007,$070
 DC.W $660,$006,$060
 DC.W $550,$005,$050
 DC.W $440,$004,$040
 DC.W $330,$003,$030
 DC.W $220,$002,$020
 DC.W $110,$001,$010
 DC.W $000,$000,$000

 DC.W 0,0
;N@=N@+1
; UNTILEQ N@,2

MOUSE:
 DC.B $12,$1A,$14,8

ASCII:
 DS.B 25,' '
 DC.B "WHO SAID THAT STALIN ONLY MAKES BORING SINGLE BITPLANE SCREENS? "
 DC.B 'THESE SPRITES ARE BIGGER THAN THOSE IN MY WATTAHECK SCREEN, '
 DC.B 'AND THEY ARE 4 BITPLANES TOO! '
 DC.B 'HELLO TO ALL COMPUTER MANIACS OUT THERE...'
 DS.B 25,' '
 DC.B 0
ASCEND:
 ALIGN.W

SCREENS:
 DC.L SCR1,SCR2

CLOCK:
 DC.W 0,0

MUSIC:
 IBYTES QUIZ.IMG

SYSFONT:
 IBYTES SYSFONT.DAT

REFLEXY1:
 IBYTES REFLEXX1.SIN
 DC.W 0

REFLEXX1:
 IBYTES BALLDISX.SIN
 DC.W 0

REFLEXX2:
 IBYTES BALLDIX2.SIN
 DC.W 0

MEGAY:
 IBYTES MEGAY.SIN
 DC.W 0

MEGAX:
 IBYTES MEGAX.SIN
 DC.B $60,0
 ALIGN.W

REFLEXDAT:
 IBYTES REFLEX.DAT

GRAF:
 IBYTES MEGAFF.DAT

MEGAGX:

MEGABGX EQU MEGAGX+(4096*8)

REFGRAF EQU MEGAGX+(4096*16)  ;49152 BYTES

SCROLLER EQU MEGAGX+(4096*16)+49152

 END

 